@extends('layouts.admin')



@section('styles')

@endsection



@section('content')

<!-- ============================================================== -->

<!-- Start right Content here -->

<!-- ============================================================== -->

<div class="content-page">

    <!-- Start content -->

    <div class="content">

        <div class="container-fluid">



            <div class="row">

                <div class="col-sm-12">

                    <div class="page-title-box">

                        <div class="row align-items-center">

                            <div class="col-md-8">

                                <h4 class="page-title mb-0">Welcome to your Dashboard</h4>



                            </div>



                        </div>



                    </div>

                </div>

            </div>

            <!-- end row -->



            <div class="row">

                <div class="col-xl-4 col-md-6">

                    <div class="card mini-stats">

                        <div class="p-3 mini-stats-content">



                        </div>

                        <div class="ml-3 mr-3">

                            <div class="bg-white p-3 mini-stats-desc rounded">

                                <h4 class="float-right mt-1 text-success">{{$studentcount}}</h4>

                                <h5 class="mt-1 mb-1">Registered Students</h5>



                            </div>

                        </div>

                    </div>

                </div>

                <div class="col-xl-4 col-md-6">

                    <div class="card mini-stats">

                        <div class="p-3 mini-stats-content">



                        </div>

                        <div class="ml-3 mr-3">

                            <div class="bg-white p-3 mini-stats-desc rounded">

                                <h4 class="float-right mt-1 text-info">{{$teachercount}}</h4>

                                <h5 class="mt-1 mb-1">Registered Teachers</h5>


                            </div>

                        </div>

                    </div>

                </div>

                <div class="col-xl-4 col-md-6">

                    <div class="card mini-stats">

                        <div class="p-3 mini-stats-content">



                        </div>

                        <div class="ml-3 mr-3">

                            <div class="bg-white p-3 mini-stats-desc rounded">

                                <h4 class="float-right mt-1 text-danger">{{$pendingpayment}}</h4>

                                <h5 class="mt-1 mb-1">Pending Payments</h5>



                            </div>

                        </div>

                    </div>

                </div>



            </div>

            <!-- end row -->


<!-- end row -->

                        <div class="row">
                            <div class="col-xl-7">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="mt-0 header-title mb-5">Students Registration</h4>
                                        <div id="morris-bar-stacked" class="morris-chart-height morris-charts"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-5">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="mt-0 header-title">Courses Registrations</h4>

                                        <div class="row text-center m-t-20">
                                          @foreach($gradereg as $gr)
                                            <div class="col-3">
                                                <h5 class="">{{$gr->total}}</h5>
                                                @php $go = App\Modals\Grade::where('id', $gr->grade_id)->first();  @endphp
                                                <p class="text-muted font-14">{{$go->name}}</p>
                                            </div>
                                            @endforeach
                                            <!-- <div class="col-3">
                                                <h5 class="">8</h5>
                                                <p class="text-muted font-14">Grade 10</p>
                                            </div>
											 <div class="col-3">
                                                <h5 class="">864</h5>
                                                <p class="text-muted font-14">Grade 11</p>
                                            </div>
											 <div class="col-3">
                                                <h5 class="">843</h5>
                                                <p class="text-muted font-14">Grade 12</p>
                                            </div> -->
                                        </div>

                                        <div id="morris-donut-example" class="dash-chart morris-charts text-center"></div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <!-- end row -->


            <div class="row">

                <div class="col-lg-12">

                    <div class="card">

                        <div class="card-body">

                            <h4 class="mt-0 header-title">Student Registration Requests (Fee not paid yet)</h4>

                            <div class="table-responsive mt-4">

                              <table class="table table-hover mb-0">
                                  <thead>
                                      <tr>
                                          <th scope="col">(#)</th>
                                          <th scope="col">Name</th>
                                          <th scope="col">Email</th>
                                          <th scope="col">Grade</th>
                                          <th scope="col">Course</th>
                                          <th scope="col">Status</th>
                                          <th scope="col" colspan="2">Actions</th>
                                      </tr>
                                  </thead>
                                  <tbody>
                                    @foreach($students as $student)
                                      <tr>
                                          <th scope="row">{{$loop->iteration}}</th>
                                          <td>{{$student->student->given_name}}</td>

                                          <td>{{$student->student->user->email}}</td>
                                          <td>{{$student->grade->name}}</td>
                                          <td>{{$student->course->name}}</td>
                                          <td>@if($student->status == 0)
                                            <span class="label label-danger">Payment Pending</span>
                                            @else
                                            @endif
                                          </td>
                                          <td>
                                              <div>
                                                  <!-- <a data-toggle="modal" data-target="#approveModal" class="btn btn-success btn-sm"><i class="fa fa-check" onclick="setregid({{$student->id}})"></i>Approve</a> -->
                                                  <a href="#" class="btn btn-primary btn-sm"><i class="fa fa-eye"></i>Details</a>
                                              </div>
                                          </td>
                                      </tr>
                                    @endforeach
                                  </tbody>
                              </table>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <!-- end row -->



        </div> <!-- container-fluid -->



    </div> <!-- content -->



    <footer class="footer">

        © 2020 - 2021  The Educators Academy

    </footer>

</div>





<!-- ============================================================== -->

<!-- End Right content here -->

<!-- ============================================================== -->



@endsection



@section('scripts')
  <!-- script src="{{ asset('assets/admin/pages/dashboard.js')}}"></script> -->
<script>
/*
 Template Name: Foxia - Responsive Bootstrap 4 Admin Dashboard
 Author: Themesbrand
 File: Dashboard js
 */

!function ($) {
    "use strict";

    var Dashboard = function () {
    };

        //creates Stacked chart
        Dashboard.prototype.createStackedChart  = function(element, data, xkey, ykeys, labels, lineColors) {
            Morris.Bar({
                element: element,
                data: data,
                xkey: xkey,
                ykeys: ykeys,
                stacked: true,
                labels: labels,
                hideHover: 'auto',
                resize: true, //defaulted to true
                gridLineColor: '#eeeeee',
                barColors: lineColors
            });
        },

        //creates Donut chart
        Dashboard.prototype.createDonutChart = function (element, data, colors) {
            Morris.Donut({
                element: element,
                data: data,
                resize: true,
                colors: colors,
            });
        },

        // pie
        $('.peity-pie').each(function () {
            $(this).peity("pie", $(this).data());
        });

        //donut
        $('.peity-donut').each(function () {
            $(this).peity("donut", $(this).data());
        });

        // line
        $('.peity-line').each(function () {
            $(this).peity("line", $(this).data());
        });


        Dashboard.prototype.init = function () {

            //creating Stacked chart
            var $stckedData  = [
                { y: 'week1', a: 245 },
                { y: 'week2', a: 175 },
                { y: 'week3', a: 160},
                { y: 'week4', a: 175 }

            ];
            this.createStackedChart('morris-bar-stacked', $stckedData, 'y', ['a'], ['Registered Students'], ['#655be6']);


            //creating donut chart
            var $donutData = [
              @foreach($gradereg as $gr1)
              @php $go1 = App\Modals\Grade::where('id', $gr1->grade_id)->first();  @endphp
                {label: "{{$go1->name}}", value: "{{$gr1->total}}"},
                @endforeach
            ];
            this.createDonutChart('morris-donut-example', $donutData, ['#46cd93', '#655be6', '#1699dd', '#fdba45']);


        },
        //init
        $.Dashboard = new Dashboard, $.Dashboard.Constructor = Dashboard
}(window.jQuery),

//initializing
    function ($) {
        "use strict";
        $.Dashboard.init();
    }(window.jQuery);


</script>

@endsection
